package com.ejie.p06b.dao;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import org.apache.xml.security.utils.Base64;



import com.ejie.p06b.datatype.model.P06B83T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;
/**
 * Fecha de creacin: (15/01/2010)
 */
public class P06B83T00DAO {
	
	static private P06B83T00DAO instance = null;

	public static P06B83T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B83T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B83T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	/**
    * Actualiza todos los registros de la BD
    * @param datosDireccion.
    *            objeto a insertar
    * @return P06B83T00Datatype el documento insertado
    * @throws SQLException
    */
	public P06B83T00Datatype updateAll(P06B83T00Datatype datosDireccion) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B83T00DAO-updateAll");
		
		PreparedStatement lstm  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        
        String sql = UPDATEALL;
        lstm = lconConexion.prepareStatement(sql);
    	
        lstm.setString(1,datosDireccion.getDescDireccionEus());
	    lstm.setString(2,datosDireccion.getDescDireccionCas());
	    lstm.setString(3,datosDireccion.getNombre());
	    lstm.setString(4,datosDireccion.getApe1());
	    lstm.setString(5,datosDireccion.getApe2());
	    lstm.setString(6,datosDireccion.getTipoImagenFirma());
	    
	    //Insertar el dato de tipo BLOB
	    if(datosDireccion.getImagenFirma() == null){
	    	lstm.setNull(7, Types.BLOB);
	    }else{
	    	InputStream is = new ByteArrayInputStream(datosDireccion.getImagenFirma());
	    	lstm.setBinaryStream(7, is, datosDireccion.getImagenFirma().length);
	    }
	    
    	lstm.executeUpdate();
    	lstm.close();
    	lconConexion.close();
        P06BLog.send(2,this, "Fin P06B83T00DAO-updateAll");
        return datosDireccion;
	}
	
	/**
    * Obtiene la lista de documentos asociados al expediente
    * @param expediente.       
    * @return Lista de objetos de documentos
	 * @throws IOException 
	 * @throws Exception
    */
	public P06B83T00Datatype selectAll() throws SQLException, IOException{
		P06BLog.send(2,this, "Inicio P06B83T00Datatype-selectAll");
		P06B83T00Datatype datosDireccion = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        
    	lstm = lconConexion.prepareStatement(sql);
    	
    	lrst = lstm.executeQuery();
        if (lrst.next()) {
        	datosDireccion = new P06B83T00Datatype();
        	datosDireccion.setDescDireccionEus(lrst.getString(P06BTablas.P06B_P06B83_DESCDIRECCIONEUS));
        	datosDireccion.setDescDireccionCas(lrst.getString(P06BTablas.P06B_P06B83_DESCDIRECCIONCAS));
        	datosDireccion.setNombre(lrst.getString(P06BTablas.P06B_P06B83_NOMBRE));
        	datosDireccion.setApe1(lrst.getString(P06BTablas.P06B_P06B83_APE1));
        	datosDireccion.setApe2(lrst.getString(P06BTablas.P06B_P06B83_APE2));
        	datosDireccion.setTipoImagenFirma(lrst.getString(P06BTablas.P06B_P06B83_TIPOIMAGENFIRMA));
		    
		    //Descargar el dato de tipo BLOB
        	byte[] doc = null;
    		InputStream is = null;
    		
			is = lrst.getBinaryStream(P06BTablas.P06B_P06B83_IMAGENFIRMA);
			if (is != null ){
	    		ByteArrayOutputStream bos = new ByteArrayOutputStream();
				int leido = -1;
				while ((leido = is.read()) != -1 ){
					bos.write( leido );
				}
				doc = bos.toByteArray();
			}
			datosDireccion.setImagenFirma(doc);
			String base64 = Base64.encode(doc);
			datosDireccion.setImagenFirmaBase64(base64);

        }
		lrst.close();
		lstm.close();
		lconConexion.close();
        P06BLog.send(2,this, "Fin P06B83T00Datatype-selectAll");
		return datosDireccion;
	}

	private static String UPDATEALL =
		"UPDATE "+ P06BTablas.P06B_P06B83T00_TABLA + " SET " +
		P06BTablas.P06B_P06B83_DESCDIRECCIONEUS + "=?," +
		P06BTablas.P06B_P06B83_DESCDIRECCIONCAS + "=?," +
		P06BTablas.P06B_P06B83_NOMBRE + "=?," +
		P06BTablas.P06B_P06B83_APE1 + "=?," +
		P06BTablas.P06B_P06B83_APE2 + "=?," +
		P06BTablas.P06B_P06B83_TIPOIMAGENFIRMA + "=?," +
		P06BTablas.P06B_P06B83_IMAGENFIRMA + "=?";
	
	private static String SELECTALL =
		"SELECT " +
		P06BTablas.P06B_P06B83_DESCDIRECCIONEUS + "," +
		P06BTablas.P06B_P06B83_DESCDIRECCIONCAS + "," +
		P06BTablas.P06B_P06B83_NOMBRE + "," +
		P06BTablas.P06B_P06B83_APE1 + "," +
		P06BTablas.P06B_P06B83_APE2 + "," +
		P06BTablas.P06B_P06B83_TIPOIMAGENFIRMA + "," +
		P06BTablas.P06B_P06B83_IMAGENFIRMA + 
		" FROM " + P06BTablas.P06B_P06B83T00_TABLA;

}
